/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : D/I and D/O
/* - Contents:  α׷ COMILX_DO_PutOne(..) COMILX_DI_GetOne(..) Լ 
/*     Ͽ  1äο  D/I D/O ϴ Դϴ.
/* - Remarks : 
/*     1.   COMI-LX101 带 ϴ  ۼǾϴ.
/*         ٸ 带 ϴ 쿡 COMILX_LoadDevice(...)Լ 
/*        ù ° Ķ͸ ˸ ̽ ID ٲپ մϴ.   
/*     2.  α׷ D/O ä 0 Ͽ On/Off ȣ ư鼭 
/*        D/I ä 0 о̴ α׷Դϴ. D/O 0 äΰ D/I 0 ä 
/*         س D/O  ȣ D/I äο оϼ ֽϴ.
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "ComidasLX.h"

#define DEV_ID	COMI_LX101
#define DO_CH	0
#define DI_CH	0

void main (void)
{
	HANDLE hDevice;
	int do_state=0, di_state;

	if(!COMILX_LoadDll()){
		printf("ComidasLX.dll load failure");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	hDevice = COMILX_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMILX_UnloadDll();
		exit(0);
	}

	printf("DIO ׽Ʈ Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	
	COMILX_DIO_SetUsage(hDevice, DI_DO);
	while(!kbhit())
	{
		do_state ^= 1;  // state  
		COMILX_DO_PutOne (hDevice, DO_CH, do_state); // Put D/O  
		
		/* Get D/I and print on screen */
		di_state = COMILX_DI_GetOne(hDevice, DI_CH);
		printf("Status of D/I CH0 = %d\n", di_state);
		Sleep(500);
	}

	
	COMILX_UnloadDevice(hDevice);
	COMILX_UnloadDll();
}
